create or replace package tbicds.PCK_MESSAGES
AUTHID CURRENT_USER
is

/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --return recordsets
  type RetRefCursor is ref cursor;

  procedure GetUserMessagesRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vKey             in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetDeletedMessagesRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vKey             in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor);

  procedure GetUnreadMessagesRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  procedure GetSentMessagesRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vKey             in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetRecipientsListRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nMessageID       in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor);

  procedure SendMessage(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        
                        pi_vKey        in varchar2,
                        pi_vRecipients in varchar2,
                        pi_vSubject    in varchar2,
                        pi_clobBody    in clob,
                        po_nMessageID  out number,
                        
                        po_nStatusCode    out number,
                        po_vStatusComment out varchar2);

  procedure MarkAsRead(pi_vSessionID       in varchar2,
                       pi_vSessionClientIP in varchar2,
                       pi_nUserID          in number,
                       pi_nMessageID       in number,
                       po_nStatusCode      out number,
                       po_vStatusComment   out varchar2);

  procedure MarkAsDeleted(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_nMessageID       in number,
                          pi_nIsSentMsg       in number,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2);

  procedure GetProviderPatientsRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vKey             in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor);

  procedure GetAllProviderRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor);

  function fGetRecipientsList(pi_vKey in varchar2, pi_nMessageID varchar2)
    return varchar2;

  procedure BulkSendMessages(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             
                             pi_nMessageID in number,
                             pi_vRecipient in varchar2,
                             pi_vSubject   in varchar2,
                             pi_clobBody   in clob,
                             
                             po_nStatusCode    out number,
                             po_vStatusComment out varchar2);

  -- **************************************************************
  --  SEND EXTERNAL MESSAGE NOTIFICATION
  procedure SendExternalNotification(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     pi_vKey             in varchar2,
                                     pi_nMessageID       in number,
                                     po_nStatusCode      out number,
                                     po_vStatusComment   out varchar2);

end;
/

